<?php

    namespace App\System\Plugin;
    use App\System\Basic\beModel;
    use App\System\Basic\beRouter;
    use App\System\Controller\ConnectionController;
use App\System\Model\SettingGroupsModel;
use App\System\Model\SettingModel;
use App\System\Vendor\Auth;
    use App\System\Vendor\beModule;
    use App\System\Vendor\bePlugin;

    class iyzico_helper {
        public function plugin_info(){
            return [
                "name" => "Iyzico Eklentisi",
                "description" => "Iyzico modülününü çalışması için gerekli alt yapıyı sağlar",
                "version" => "1.0",
                "vercode" => 1,
                "author" => "ITenGriTR"
            ];
        }
        public function plugin_hooks(){
            return [
                "routes_start" => "my_routes_insert"
            ];
        }
        public function plugin_settings(){
            $settinggroup = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","iyzico")->beGet();
            return ["status" => true,"url" => beGetRoute("admin.settings.settinggroup.show",["sgid" => $settinggroup["sgid"]])];
        }
        public function plugin_install(){
            $sgid = bePlugin::beCreateSettingGroup("iyzico","Iyzico Ödeme Yöntemi","Iyzico ödeme yöntemi için gerekli ayarları yükler");
            bePlugin::beCreateSetting($sgid,"iyzico_status","Durum","Iyzico ödeme yöntemi aktiflik durumu","select\n0=Kapalı\n1=Açık","0");
            bePlugin::beCreateSetting($sgid,"iyzico_store_card","Kart Saklama","Iyzico ödeme yönteminde kart saklama durumunu seçiniz","select\n0=Kapalı\n1=Açık","0");
            bePlugin::beCreateSetting($sgid,"iyzico_merchant_id","Üye İşyeri Numarası","Iyzico paneli üzerinde firma ayarları alanında üye işyeri numarası","int");
            bePlugin::beCreateSetting($sgid,"iyzico_merchant_key","API Anahtarı","Iyzico paneli üzerinde firma ayarları alanındaki api anahtarı","str");
            bePlugin::beCreateSetting($sgid,"iyzico_merchant_secret","API Güvenlik Anahtarı","Iyzico paneli üzerinde firma ayarları alanındaki api güvenlik anahtarı","str");
            bePlugin::beCreateSetting($sgid,"iyzico_methodfee","Komisyon Oranı","Iyzico ödeme yöntemi için eklenecek olan ekstra komisyon","int");
            beModel::beQuery("CREATE TABLE `be_iyzico_cards` (`icid` int(11) NOT NULL,`uid` int(11) NOT NULL,`iid` int(11) NOT NULL,`iccardnumber` varchar(16) NOT NULL,`iccardexpire` varchar(8) NOT NULL,`icipaddress` varchar(64) NOT NULL,`icdateline` int(11) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;ALTER TABLE `be_iyzico_cards` ADD PRIMARY KEY (`icid`);CREATE TABLE `be_iyzico_card_storage` (`icid` int(11) NOT NULL,`uid` int(11) NOT NULL,`iccardid` varchar(32) NOT NULL,`iccardtoken` varchar(32) NOT NULL,`icbinnumber` varchar(6) NOT NULL,`iclastfour` varchar(4) NOT NULL,`icname` varchar(128) NOT NULL,`ictype` varchar(16) NOT NULL,`icassociation` varchar(16) NOT NULL,`icfamily` varchar(16) NOT NULL,`icbankname` varchar(32) NOT NULL,`icdateline` int(11) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;ALTER TABLE `be_iyzico_card_storage` ADD PRIMARY KEY (`icid`);CREATE TABLE `be_iyzico_card_user` (`uid` int(11) NOT NULL,`icusertoken` varchar(32) NOT NULL,`icdateline` int(11) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;")->beExecute();
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti kuruldu!"];
        }
        public function plugin_remove(){
            beModel::beQuery("DROP TABLE be_iyzico_cards,be_iyzico_card_storage,be_iyzico_card_user")->beExecute();
            $sgid = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","iyzico")->beGet()["sgid"];
            SettingGroupsModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            SettingModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti silindi!"];
        }
        public function my_routes_insert(){
            beRouter::bePrefix("/iyzico","iyzico.")->beGroup(function(){
                beRouter::beRoute("/delete-card","iyzico_helper@delete_post","post")->beName("card.delete.post")->beSpecial()->beMiddleWare("Auth");
            });
        }
        public function delete_post(){
            $user = Auth::beGetUser();
            $icid = (int)$_POST["cid"];
            $cardstorage = beModel::beTable("be_iyzico_card_storage")->beSelect("icid,iccardtoken")->beWhere("icid",$icid)->beWhere("uid",$user["uid"])->beGet();
            if(!$cardstorage){
                return beAjaxError(["message" => "Belirtilen kart sistem üzerinde bulunamadı!"]);
            }
            $response = beModule::beLoadModule("payment.iyzico");
            if(!$response["status"]){
                return beAjaxError(["message" => "Belirtilen modül bulunamadı!"]);
            }
            if(!beModule::beCheckModuleFunction("iyzico","delete_card")){
                return beAjaxError(["message" => "Kart silme fonksiyonu modül üzerinde bulunamadı!"]);
            }
            $carduser = beModel::beTable("be_iyzico_card_user")->beWhere("uid",$user["uid"])->beGet();
            $response = beModule::beRunModuleFunction("iyzico","delete_card",[
                "carduser_key" => $carduser["icusertoken"],
                "card_token" => $cardstorage["iccardtoken"]
            ]);
            if(!$response["status"]){
                return beAjaxError(["message" => $response["message"]]);
            }
            beModel::beDelete("be_iyzico_card_storage")->beWhere("icid",$cardstorage["icid"])->beExecute();
            $cardstoragecount = beModel::beTable("be_iyzico_card_storage")->beSelect("COUNT(icid) as total")->beWhere("uid",$user["uid"])->beGet()["total"];
            if($cardstoragecount == 0){
                beModel::beDelete("be_iyzico_card_user")->beWhere("uid",$user["uid"])->beExecute();
            }
            return beAjaxSuccess(["message" => "Belirtilen kart başarılı bir şekilde silindi!","refresh" => 1]);
        }
    }

?>