<?php

    namespace App\System\Plugin;
    use App\System\Basic\beModel;
    use App\System\Basic\beRouter;
    use App\System\Model\SettingGroupsModel;
    use App\System\Model\SettingModel;
    use App\System\Vendor\beModule;
    use App\System\Vendor\bePlugin;

    class gib_helper {
        public function plugin_info(){
            return [
                "name" => "Gib Eklentisi",
                "description" => "GİB modülününü çalışması için gerekli alt yapıyı sağlar",
                "version" => "1.0",
                "vercode" => 1,
                "author" => "ITenGriTR"
            ];
        }
        public function plugin_hooks(){
            return [
                "routes_start" => "be_routes_insert"
            ];
        }
        public function plugin_settings(){
            return ["status" => true,"url" => beGetRoute("gib.dashboard")];
        }
        public function plugin_install(){
            $sgid = bePlugin::beCreateSettingGroup("gib","Gib Fatura Resmileştirme","GİB modülü için gerekli ayarları yükler");
            bePlugin::beCreateSetting($sgid,"gib_status","Durum","GİB fatura resmişleştirmeaktiflik durumu","select\n0=Kapalı\n1=Açık","0");
            bePlugin::beCreateSetting($sgid,"gib_username","Gib Kullanıcı Kodu","Gib e-arşiv portal sistemine giriş için kullandığınız kullanıcı kodu","str");
            bePlugin::beCreateSetting($sgid,"gib_password","Gib Şifre","Gib e-arşiv portal sistemine giriş için kullandığınız şifre","str");
            bePlugin::beCreateSetting($sgid,"gib_global","Gib Genel Fatura","Gib üzerinde yurt dışından satın alım yapanlar için fatura oluştur","bool");
            bePlugin::beCreateSetting($sgid,"gib_default_no","Gib Yurt Dışı Kimlik Numarası","Gib üzerinde yurt dışı müşterilerine fatura kesilecekse atanacak olan TC Kimlik değeri","str","11111111111");
            bePlugin::beCreateSetting($sgid,"gib_data","Gib Data","","json","","");
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti kuruldu!"];
        }
        public function plugin_remove(){
            $sgid = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","gib")->beGet()["sgid"];
            SettingGroupsModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            SettingModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti silindi!"];
        }
        public function be_routes_insert(){
            beRouter::bePrefix("/gib","gib.")->beGroup(function(){
                beRouter::beRoute("/","gib_helper@dashboard")->beName("dashboard")->beSpecial()->beMiddleWare(["Auth","Admin" => ["permission" => "admin_plugin_edit"]]);
                beRouter::beRoute("/test-connection","gib_helper@tect_connection_post","post")->beName("test.connetcion.post")->beSpecial()->beMiddleWare(["Auth","Admin" => ["permission" => "admin_plugin_edit"]]);
            });
        }
        public function dashboard(){
            $settinggroup = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","gib")->beGet();
            return beGetView("plugins.gib.dashboard",["settingsurl" => beGetRoute("admin.settings.settinggroup.show",["sgid" => $settinggroup["sgid"]])]);
        }
        public function tect_connection_post(){
            beModule::beLoadModule("invoice.gib");
            $response = beModule::beRunModuleFunction("gib","login");
            if(!$response["status"]){
                return beAjaxError(["message" => $response["message"]]);
            }
            beModule::beRunModuleFunction("gib","logout",["token" => $response["token"]]);
            return beAjaxSuccess(["message" => $response["message"]]);
        }
    }

?>