<?php

    namespace App\System\Plugin;
    use App\System\Basic\beModel;
    use App\System\Basic\beRouter;
use App\System\Model\SettingGroupsModel;
use App\System\Model\SettingModel;
use App\System\Vendor\beModule;
    use App\System\Vendor\bePlugin;

    class banner {
        public function plugin_info(){
            return [
                "name" => "Üst Reklam Eklentisi",
                "description" => "Sitenizin en üstünde reklam gözükmesini sağlar",
                "version" => "1.0",
                "vercode" => 1,
                "author" => "ITenGriTR"
            ];
        }
        public function plugin_hooks(){
            return [
                "template_preparation_header" => "my_template_preparation_header"
            ];
        }
        public function plugin_settings(){
            $settinggroup = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","banner")->beGet();
            return ["status" => true,"url" => beGetRoute("admin.settings.settinggroup.show",["sgid" => $settinggroup["sgid"]])];
        }
        public function plugin_install(){
            $sgid = bePlugin::beCreateSettingGroup("banner","Üst Reklam Ayarları","Üst reklam için gerekli ayarlamaları yapmayı sağlar");
            bePlugin::beCreateSetting($sgid,"banner_status","Durum","Üst reklamın aktiflik durumu","select\n0=Kapalı\n1=Açık","0");
            bePlugin::beCreateSetting($sgid,"banner_class","Ekstra Sınıf","Üst reklamınıza ekstra olarak sınıf ekleyiniz","str","text-normal text-lg");
            bePlugin::beCreateSetting($sgid,"banner_text","Mesaj","Üst reklam alanında gözükecek olan mesaj","str","Tüm yeni ürünlerde %50 indirim kampanyası sizlerle!");
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti kuruldu!"];
        }
        public function plugin_remove(){
            $sgid = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","banner")->beGet()["sgid"];
            SettingGroupsModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            SettingModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti silindi!"];
        }
        public function my_template_preparation_header($data = []){
            $settings = SettingModel::beGetSettings("banner_status,banner_class,banner_text");
            if($settings["banner_status"]){
                $data["header"] = "<div class=\"{$settings['banner_class']}\" style=\"padding:16px 0px;text-align:center;color:#484343;border-bottom:1px solid #e0e2e9;\">{$settings['banner_text']}</div>".$data["header"];
            }
            return $data;
        }
    }

?>