<?php

    namespace App\System\Plugin;
    use App\System\Model\SettingGroupsModel;
    use App\System\Model\SettingModel;
    use App\System\Vendor\bePlugin;

    class bank_helper {
        public function plugin_info(){
            return [
                "name" => "Banka Eklentisi",
                "description" => "Banka modülününü çalışması için gerekli alt yapıyı sağlar",
                "version" => "1.0",
                "vercode" => 1,
                "author" => "ITenGriTR"
            ];
        }
        public function plugin_hooks(){
            return [];
        }
        public function plugin_settings(){
            $settinggroup = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","bank")->beGet();
            return ["status" => true,"url" => beGetRoute("admin.settings.settinggroup.show",["sgid" => $settinggroup["sgid"]])];
        }
        public function plugin_install(){
            $sgid = bePlugin::beCreateSettingGroup("bank","Banka Ödeme Yöntemi","Banka ödeme yöntemi için gerekli ayarları yükler");
            bePlugin::beCreateSetting($sgid,"bank_status","Durum","Banka ödeme yöntemi aktiflik durumu","select\n0=Kapalı\n1=Açık","0");
            bePlugin::beCreateSetting($sgid,"bank_methodfee","Komisyon Oranı","Banka ödeme yöntemi için eklenecek olan ekstra komisyon","int","0");
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti kuruldu!"];
        }
        public function plugin_remove(){
            $sgid = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","bank")->beGet()["sgid"];
            SettingGroupsModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            SettingModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti silindi!"];
        }
    }
?>