<?php

namespace App\System\Module;

use App\System\Model\SettingModel;

class wpileti {
    public function wpileti_info(){
        return [
            "name" => "WP İleti Sistemi",
            "description" => "Sistem üzerinden yapılacak olan işlemleri ve bildirimleri WP İleti aracılığıyla da iletilmesini sağlar",
            "version" => "1.0",
            "vercode" => 10,
            "author" => "Servertize"
        ];
    }
    public function wpileti_sendmessage($data = []){
        $phone = $data["dial"] . $data["phone"];
        $message = $data["message"];
        $message = urlencode($message);
        $settings = SettingModel::beGetSettings("wpileti_apikey");
        
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => "https://my.wpileti.com/api/send-message",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode([
                "api_key"=>$settings['wpileti_apikey'],
                "receiver"=>$phone,
                "data"=>[
                    "message"=>$message
                ]
            ],JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES),
            CURLOPT_HTTPHEADER => [
                "Accept: */*",
                "Content-Type: application/json",
            ],
        ]);
        curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($err) 
            return ["status" => false,"message" => "WP İleti bir hata yakaladı hata kodu {$err} lütfen kontrol edin"];
        return ["status" => true,"message" => "Başarılı bir şekilde mesaj gönderildi"];
    }
}
?>