<?php

namespace App\System\Module;

use App\System\Basic\beRouter;
use App\System\Controller\CartController;
use App\System\Controller\NavController;
use App\System\Model\CurrencyModel;
use App\System\Model\ModuleLogModel;
use App\System\Model\ProductAddonTranslationsModel;
use App\System\Model\ProductModel;
use App\System\Model\SettingModel;
use App\System\Model\UserProductModel;
use App\System\Vendor\Auth;
use App\System\Vendor\Basic\beCookie;
use App\System\Vendor\beLanguage;
use App\System\Vendor\beModule;

class plesk {
    public $pages = [
        "/" => [
            "showmenu" => true,
            "name" => "Ana Sayfa",
            "icon" => "<i class=\"ri-home-line\"></i>"
        ],
        "islem-kayitlari" => [
            "showmenu" => true,
            "name" => "İşlem Kayıtları",
            "icon" => "<i class=\"ri-history-line\"></i>",
            "function" => "plesk_clientarea_logs"
        ],
        "format" => [
            "showmenu" => true,
            "name" => "Format",
            "icon" => "<i class=\"ri-format-clear\"></i>",
            "function" => "plesk_clientarea_format"
        ]
    ];
    public function plesk_permissions($data = []){
        return [
            [
                "ugpname" => "Sipariş Üzerinde Hesap Bilgilerini Görüntüleme",
                "ugptype" => "bool",
                "ugpcode" => "plesk_show_info",
            ],
            [
                "ugpname" => "Sipariş Üzerinde Plesk Girişi Yapabilir",
                "ugptype" => "bool",
                "ugpcode" => "plesk_login_plesk",
            ],
        ];
    }
    public function plesk_info(){
        return [
            "name" => "Plesk",
            "description" => "Plesk ile gerekli bağlantıyı kurup otomasyon sağlar",
            "version" => "1.0",
            "vercode" => 10,
            "type" => "webhost",
            "status" => 1,
            "author" => "ITenGriTR"
        ];
    }
    public function plesk_connection_test($params = []){
        $response = $this->beSendApiRequest([
            "apiurl" => $params["surl"],
            "endpoint" => "auth/keys",
            "method" => "POST",
            "data" => [
                "login_username" => $params["susername"],
                "login_password" => $params["spassword"],
            ]
        ]);
        if($response["responsecode"] != 201){
            return ["status" => false,"message" => "Girilen bilgiler üzerinde hata mevcut bağlantı kurulamadı!"];
        }
        return ["status" => true];
    }
    public function plesk_order_config(){
        return [
            "domain" => [
                "name" => "Alan Adı",
                "description" => "Kullanıcının yöneteceği temel alan adı",
                "type" => "string",
                "default" => ""
            ],
            "reseller" => [
                "name" => "Satıcı Hesabı",
                "description" => "Hesabın satıcı hesabı olup olmadığını belirleyiniz",
                "type" => "select",
                "status" => 1,
                "default" => 1,
                "values" => [
                    0 => "Normal",
                    1 => "Satıcı"
                ]
            ],
            "username" => [
                "name" => "Kullanıcı Adı",
                "description" => "Plesk üzerinde kullanılacak olan kullanıcı adı",
                "type" => "string",
                "default" => ""
            ]
        ];
    }
    public function plesk_product_config($params = []){
        return [
            "planname" => [
                "name" => "Plan Adı",
                "description" => "Plan adını giriniz(Plesk Üzerindeki)",
                "type" => "string",
                "default" => "",
                "form-view" => [
                    "class" => "col-4" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ],
            "reseller" => [
                "name" => "Reseller",
                "description" => "Bu ürünün Reseller olarak yönetilmesi için 1 istemiyorsanız 0 giriniz",
                "type" => "integer",
                "default" => "",
                "form-view" => [
                    "class" => "col-4" 
                ],
                "requirements" => [
                    "min" => 0
                ]
            ],
        ];
    }
    public function plesk_content_up($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        return beGetView("modules.plesk.contentup",["userproduct" => $userproduct,"updata" => $updata,"server" => $params["server"]]);
    }
    public function plesk_preconfiguration($params){
        beLanguage::beReadLang("module");
        $addonname = "";
        foreach($params["productaddons"] as $addon){
            if($addon["pacode"] == "domain_name"){
                $addonname = $addon["paid"];
                break;
            }
        }
        if(!$addonname){
            echo beAjaxError(["message" => "Plesk modülünün kullanılabilmesi için domain_name kodlu Ürün Yapılandırması'nın olması gerekmektedir!"]);
            exit;
        }
        if(!$_COOKIE[$addonname]){
            if($_GET["domaintype"]){
                switch($_GET["domaintype"]){
                    case "newdomain" :
                        $settings = SettingModel::beGetSettings("domain_status");
                        if(!$settings["domain_status"]){
                            echo beAjaxError(["message" => "Alan adı sistemi şuan için aktif değil lütfen mevcut seçeneği ile devam ediniz."]);
                            exit;
                        }
                        beLanguage::beReadLang("module");
                        $modules = beModule::beLoadModules("product");
                        $module = "";
                        foreach($modules as $key => $data){
                            if($data["info"]["type"] == "domain" && $data["info"]["status"] == 1){
                                $module = $key;
                                break;
                            }
                        }
                        if(!$module){
                            echo beAjaxError(["message" => beGetLang("module_not_found")]);
                            exit;
                        }
                        $product = ProductModel::beSelect("pid")->beWhere("pmodule",$module)->beGet();
                        if(!$product){
                            echo beAjaxError(["message" => "Alan adı satın alımı için ürün bulunamadı!."]);
                            exit;
                        }
                        if(!beModule::beCheckModuleFunction($module,"checkdomain")){
                            echo beAjaxError(["message" => beGetLang("module_not_support")]);
                            exit;
                        }
                        $extension = $_GET["domainextension"];
                        $domain = $_GET["domainname1"];
                        $maindomain = $domain.$extension;
                        $response = beModule::beRunModuleFunction($module,"checkdomain",[$maindomain]);
                        if(!$response["status"]){
                            echo beAjaxError(["message" => beGetLang("module_function_error")]);
                            exit;
                        }
                        if(!$response["domains"][0]["available"]){
                            echo beAjaxError(["message" => "Belirtilen alan adı dolu gözüküyor lütfen başka eşsiz bir alan adı giriniz!"]);
                            exit;
                        }
                        $response = $this->beSendApiRequest([
                            "apiurl" => $params["server"]["surl"],
                            "endpoint" => "domains",
                            "method" => "GET",
                            "data" => [
                                "login_username" => $params["server"]["susername"],
                                "login_password" => $params["server"]["spassword"],
                                "name" => $maindomain
                            ]
                        ]);
                        if($response["responsecode"] != 200){
                            echo beAjaxError(["message" => "Plesk modülü üzerinde bir bağlantı hatası oluştu!"]);
                            exit;
                        }
                        if($response["data"][0]){
                            echo beAjaxError(["message" => "Belirtilen alan adı sistem üzerinde bulunmaktadır lütfen eşsiz bir alan adı giriniz."]);
                            exit;
                        }
                        $user = Auth::beGetUser();
                        $domain_extension = ProductAddonTranslationsModel::beSelect("patid,paid,paoptions")->beWhere("lid",$user["lid"])->beWhere("pacode","domain_extension")->beGet();
                        $domain_name = ProductAddonTranslationsModel::beSelect("patid,paid")->beWhere("lid",$user["lid"])->beWhere("pacode","domain_name")->beGet();
                        $paoptions = json_decode($domain_extension["paoptions"],true);
                        $addonkey = -1;
                        foreach($paoptions as $key => $option){
                            if($extension == $option["oname"]){
                                $addonkey = $key;
                                break;
                            }
                        }
                        if($addonkey == -1){
                            echo beAjaxError(["message" => "Belirtilen alan adı uzantısı sistem üzerinde satılmamaktadır."]);
                            exit;
                        }
                        $item = [];
                        $item[(int)$domain_extension["paid"]] = $addonkey;
                        $item[(int)$domain_name["paid"]] = $domain;
                        $item["period"] = 1;
                        $item["pid"] = $product["pid"];
                        $cartcontroller = new CartController();
                        $response = $cartcontroller->additem_post($item);
                        $response = json_decode($response,true);
                        if(!$response["status"]){
                            echo beAjaxError(["message" => $response["message"]]);
                            exit;
                        }
                        beCookie::beCreateCookie($addonname,$domain,true,true,BE_TIME+120);
                        echo beAjaxSuccess(["message" => $response["message"],"refresh" => 1]);
                        exit;
                        break;
                    case "transferdomain" :
                        echo beAjaxError(["message" => "Alan adı transfer sistemi şuan için aktif değil lütfen yeni yada mevcut seçeneği ile devam ediniz."]);
                        exit;
                        $domain = $_GET["domainname2"];
                        if(strpos($domain,".") === false){
                            echo beAjaxError(["message" => "Alan adı formatı doğru değil lütfen <b>".beGetConfig("sitename")."</b> tarzında alan adınızı giriniz"]);
                            exit;
                        }
                        $response = $this->beSendApiRequest([
                            "apiurl" => $params["server"]["surl"],
                            "endpoint" => "domains",
                            "method" => "GET",
                            "data" => [
                                "login_username" => $params["server"]["susername"],
                                "login_password" => $params["server"]["spassword"],
                                "name" => $domain
                            ]
                        ]);
                        if($response["responsecode"] != 200){
                            echo beAjaxError(["message" => "Plesk modülü üzerinde bir bağlantı hatası oluştu!"]);
                            exit;
                        }
                        if($response["data"][0]){
                            echo beAjaxError(["message" => "Belirtilen alan adı sistem üzerinde bulunmaktadır lütfen eşsiz bir alan adı giriniz."]);
                            exit;
                        }
                        beCookie::beCreateCookie($addonname,$domain,true,true,BE_TIME+120);
                        echo beAjaxSuccess(["message" => "Başarılı bir şekilde ürün yapılandırıldı!","refresh" => 1]);
                        exit;
                        break;
                    case "changedomain" :
                        $domain = $_GET["domainname3"];
                        if(strpos($domain,".") === false){
                            echo beAjaxError(["message" => "Alan adı formatı doğru değil lütfen <b>".beGetConfig("sitename")."</b> tarzında alan adınızı giriniz"]);
                            exit;
                        }
                        $response = $this->beSendApiRequest([
                            "apiurl" => $params["server"]["surl"],
                            "endpoint" => "domains",
                            "method" => "GET",
                            "data" => [
                                "login_username" => $params["server"]["susername"],
                                "login_password" => $params["server"]["spassword"],
                                "name" => $domain
                            ]
                        ]);
                        if($response["responsecode"] != 200){
                            echo beAjaxError(["message" => "Plesk modülü üzerinde bir bağlantı hatası oluştu!"]);
                            exit;
                        }
                        if($response["data"][0]){
                            echo beAjaxError(["message" => "Belirtilen alan adı sistem üzerinde bulunmaktadır lütfen eşsiz bir alan adı giriniz."]);
                            exit;
                        }
                        beCookie::beCreateCookie($addonname,$domain,true,true,BE_TIME+120);
                        echo beAjaxSuccess(["message" => "Başarılı bir şekilde ürün yapılandırıldı!","refresh" => 1]);
                        exit;
                        break;
                }
            }
            else{
                NavController::beAddBreadcumb("Alan Adı Yapılandırması");
                beSetHeaderContent();
                bePrintPage(beGetView("modules.plesk.selectdomain"));
                exit;
            }
        }
    }
    public function plesk_create($params = []){
        $userproduct = $params["userproduct"];
        $upoptions = json_decode($userproduct["upoptions"],true);
        $domain = "";
        foreach($upoptions as $option => $data){
            if($data["code"] == "domain_name"){
                $domain = $data["key"];
                break;
            }
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "endpoint" => "domains",
            "method" => "GET",
            "data" => [
                "login_username" => $params["server"]["susername"],
                "login_password" => $params["server"]["spassword"],
                "name" => $domain
            ]
        ]);
        if($response["responsecode"] != 200){
            return ["status" => false,"message" => "Plesk modülü üzerinde bir bağlantı hatası oluştu!"];
        }
        if($response["data"][0]){
            return ["status" => false,"message" => "Belirtilen alan adı sistem üzerinde bulunmaktadır lütfen yönetici ile iletişime geçiniz."];
        }
        $clienttype = "customer";
        if($params["productmodules"]["reseller"] == 1){
            $clienttype = "reseller";
        }
        else{
            $params["productmodules"]["reseller"] = 0;
        }
        $siteshortname = strtolower(str_replace(" ","",beGetConfig("siteshortname")));
        $siteshortname = str_replace(["İ","Ü","Ö","Ğ","Ç","Ş","ı","ü","ö","ğ","ç","ş"],["I","U","O","G","C","S","i","u","o","g","c","s"],$siteshortname);
        if(strlen($siteshortname) > 8){
            $siteshortname = substr($siteshortname,0,8);
        }
        $user = Auth::beGetUser();
        $username = $siteshortname.substr(md5(BE_TIME.$userproduct["upid"].rand(0,1000)),0,8);
        $password = substr(md5(rand(0,1000).BE_TIME.$userproduct["upid"].rand(0,1000)),0,10);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "endpoint" => "clients",
            "method" => "POST",
            "data" => [
                "login_username" => $params["server"]["susername"],
                "login_password" => $params["server"]["spassword"],
                "name" => $user["name"]." ".$user["surname"],
                "login" => $username,
                "password" => $password,
                "email" => $user["email"],
                "type" => $clienttype
            ]
        ]);
        if($response["responsecode"] != 201){
            $response["message"] = "Modül üzerinde kullanıcı oluşturulamadı!";
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"plesk","Kurulum Hatası","Kurulum esnasında bir sorun oluştu!",[
                "response" => $response
            ]);
            return ["status" => false,"message" => "Plesk modülü üzerinde kullanıcı oluşturulamadı!"];
        }
        $userid = $response["data"]["id"];
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "endpoint" => "domains",
            "method" => "POST",
            "data" => [
                "login_username" => $params["server"]["susername"],
                "login_password" => $params["server"]["spassword"],
                "name" => $domain,
                "hosting_type" => "virtual",
                "hosting_settings" => [
                    "ftp_login" => $username,
                    "ftp_password" => $password,
                ],
                "owner_client" => [
                    "id" => $userid,
                    "login" => $params["server"]["susername"]
                ],
                "plan" => [
                    "name" => $params["productmodules"]["planname"]
                ]
            ]
        ]);
        if($response["responsecode"] != 201){
            $response["message"] = "Modül üzerinde alan adı oluşturulamadı!";
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"plesk","Kurulum Hatası","Kurulum esnasında bir sorun oluştu!",[
                "response" => $response
            ]);
            $response = $this->beSendApiRequest([
                "apiurl" => $params["server"]["surl"],
                "endpoint" => "clients/{$userid}",
                "method" => "DELETE",
                "data" => [
                    "login_username" => $params["server"]["susername"],
                    "login_password" => $params["server"]["spassword"],
                ]
            ]);
            return ["status" => false,"message" => "Plesk modülü üzerinde alan adı oluşturulamadı!"];
        }
        $domainid = $response["data"]["id"];
        $updatedata = [];
        $updatedata["uptag"] = $domain;
        $updata = [
            "domain" => $domain,
            "username" => $username,
            "password" => $password,
            "userid" => $userid,
            "domainid" => $domainid,
            "plan" => $params["productmodules"]["planname"],
            "reseller" => $params["productmodules"]["reseller"]
        ];
        $updatedata["updata"] = json_encode($updata,JSON_UNESCAPED_UNICODE);
        UserProductModel::beUpdate($updatedata)->beWhere("upid",$userproduct["upid"])->beExecute();
        return ["status" => true,"message" => "Ürün yönetim paneline yönlendiliriliyorsunuz","url" => beGetRoute("client.userproduct.userproduct.show",["upid" => $userproduct["upid"]])];
    }
    public function plesk_manage($params = []){
        $userproduct = $params["userproduct"];
        beCookie::beCreateCookie("be_upid",$userproduct["upid"],true,true);
        return ["status" => true,"message" => "Ürün yönetim paneline yönlendiliriliyorsunuz","url" => beGetRoute("client.userproduct.userproduct.show",["upid" => $userproduct["upid"]])];
    }
    public function plesk_extend($params = []){
        return ["status" => true];
    }
    public function plesk_suspend($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "endpoint" => "clients/{$updata['userid']}/suspend",
            "method" => "PUT",
            "data" => [
                "login_username" => $params["server"]["susername"],
                "login_password" => $params["server"]["spassword"],
            ]
        ]);
        if($response["responsecode"] != 200){
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"plesk","Askıya Alma Hatası","Askıya alma esnasında bir sorun oluştu!",[
                "response" => $response
            ]);
            return ["status" => false,"message" => "Hizmet askıya alınırken modül üzerinde bir sorun oluştu"];
        }
        return ["status" => true,"message" => "Başarılı bir şekilde sipariş modül üzerinde askıya alındı!"];
    }
    public function plesk_unsuspend($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "endpoint" => "clients/{$updata['userid']}/activate",
            "method" => "PUT",
            "data" => [
                "login_username" => $params["server"]["susername"],
                "login_password" => $params["server"]["spassword"],
            ]
        ]);
        if($response["responsecode"] != 200){
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"plesk","Askıdan Çıkarma Hatası","Askıdan çıkarma esnasında bir sorun oluştu!",[
                "response" => $response
            ]);
            return ["status" => false,"message" => "Hizmet askıdan çıkartılırken modül üzerinde bir sorun oluştu"];
        }
        return ["status" => true,"message" => "Başarılı bir şekilde sipariş modül üzerinde askıdan kaldırıldı!"];
    }
    public function plesk_terminate($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "endpoint" => "domains/{$updata['domainid']}",
            "method" => "DELETE",
            "data" => [
                "login_username" => $params["server"]["susername"],
                "login_password" => $params["server"]["spassword"],
            ]
        ]);
        $clientresponse = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "endpoint" => "clients/{$updata['userid']}",
            "method" => "DELETE",
            "data" => [
                "login_username" => $params["server"]["susername"],
                "login_password" => $params["server"]["spassword"],
            ]
        ]);
        if(!in_array($response["responsecode"],[200,404])){
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"plesk","Silme Hatası","Silme esnasında bir sorun oluştu!",[
                "response" => $response
            ]);
            return ["status" => false,"message" => "Hizmet silinirken modül üzerinde bir sorun oluştu"];
        }
        return ["status" => true,"message" => "Başarılı bir şekilde sipariş modül üzerinde silindi!"];
    }
    public function plesk_clientarea($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $url = $params["url"];
        $page = $params["page"];
        beLanguage::beReadLang("plesk");
        $upoptions = json_decode($userproduct["upoptions"],true);
        $currencie = CurrencyModel::beGetCurrencies("cicon",$userproduct["cid"]);
        $orderinfo = [
            "product" => $userproduct["pname"],
            "billingprice" => $upoptions["period"]["price"],
            "billingcycle" => ProductModel::beGetPeriods()[$upoptions["period"]["period"]],
            "regdate" => date("d.m.Y",$userproduct["upstime"]),
            "nextduedate" => date("d.m.Y",$userproduct["upntime"]),
            "amount" => $userproduct["upprice"],
            "currencie" => $currencie
        ];
        if($page){
            $pageinfo = $this->pages[$page];
            if($pageinfo){
                $params["title"] = $pageinfo["name"];
                NavController::beAddBreadcumb($pageinfo["name"]);
                $function = $pageinfo["function"];
                $content = $this->$function($params);
            }
            else{
                $content = "Bu sayfa bulunamadı!";
            }
        }
        else{
            $content = beGetView("modules.plesk.show",[
                "userproduct" => $userproduct,
                "updata" => $updata,
                "server" => $params["server"],
                "orderinfo" => $orderinfo,
            ]);
        }
        $altmenu = [];
        $menuitems = [];
        foreach($this->pages as $pageurl => $data){
            if(!$data["showmenu"]){
                continue;
            }
            $texturl = "";
            if($pageurl == "/"){
                $texturl = $url;
            }
            else{
                $texturl = $url."/".$pageurl;
            }
            $menuitems[] = [
                "name" => $data["name"],
                "icon" => $data["icon"],
                "url" => $texturl
            ];
        }
        $altmenu[] = [
            "name" => "Plesk Yönetimi",
            "menuitems" => $menuitems
        ];
        return [
            "status" => true,
            "title" => "Hosting Yönetimi",
            "content" => $content,
            "menus" => $altmenu
        ];
    }
    public function plesk_clientarea_logs($params){
        $userproduct = $params["userproduct"];
        $user = Auth::beGetUser();
        $page = (int)$_GET["page"];
        if(!$page){
            $page = 1;
        }
        $itemcount = ModuleLogModel::beSelect("COUNT(mlid) as total")->beWhere("upid",$userproduct["upid"])->beWhere("mlonlyadmin","0")->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,$params["url"],15,"user");
        $items = ModuleLogModel::beSelect("mlid,mlname,mldescription,mldata,mldateline")->beWhere("upid",$userproduct["upid"])->beWhere("mlonlyadmin","0");
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $items = $items->beOrder("mlid","DESC")->beGetAll();
        beSetHeaderContent("",1);
        return beGetView("modules.plesk.logs",["items" => $items,"itemcount" => $itemcount,"paganation" => $paganation]);
    }
    public function plesk_clientarea_format($params){
        return beGetView("modules.plesk.format",["userproduct" => $params["userproduct"]]);
    }
    public function plesk_format($params){
        $userproduct = $params["userproduct"];
        if(!$_POST["approval"]){
            return beAjaxError(["message" => "Lütfen tüm bilgilerinizin siliniceğini onaylayın!"]);
        }
        $updata = json_decode($userproduct["updata"],true);
        $domain = $updata["domain"];
        $username = $updata["username"];
        $password = $updata["password"];
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "endpoint" => "domains/{$updata['domainid']}",
            "method" => "DELETE",
            "data" => [
                "login_username" => $params["server"]["susername"],
                "login_password" => $params["server"]["spassword"],
            ]
        ]);
        if(!in_array($response["responsecode"],[200,404])){
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"plesk","Format Silme Hatası","Format atılırken silme esnasında bir sorun oluştu!",[
                "response" => $response
            ]);
            return beAjaxError(["message" => "Plesk kurulumunda bir sorun oluştu lütfen yönetici ile iletişime geçiniz."]);
        }
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "endpoint" => "domains",
            "method" => "POST",
            "data" => [
                "login_username" => $params["server"]["susername"],
                "login_password" => $params["server"]["spassword"],
                "name" => $domain,
                "hosting_type" => "virtual",
                "hosting_settings" => [
                    "ftp_login" => $username,
                    "ftp_password" => $password,
                ],
                "owner_client" => [
                    "id" => $updata["userid"],
                    "login" => $params["server"]["susername"]
                ],
                "plan" => [
                    "name" => $params["productmodules"]["planname"]
                ]
            ]
        ]);
        if($response["responsecode"] != 201){
            $response["message"] = "Modül üzerinde alan adı oluşturulamadı!";
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"plesk","Kurulum Hatası","Kurulum esnasında bir sorun oluştu!",[
                "response" => $response
            ]);
            return beAjaxError(["message" => "Plesk kurulumunda bir sorun oluştu lütfen yönetici ile iletişime geçiniz."]);
        }
        $domainid = $response["data"]["id"];
        $updata["domainid"] = $domainid;
        UserProductModel::beUpdate(["updata" => json_encode($updata,JSON_UNESCAPED_UNICODE)])->beWhere("upid",$userproduct["upid"])->beExecute();
        return beAjaxSuccess(["message" => "Başarılı bir şekilde plesk üzerindeki alan adınız sıfırlandı!"]);
    }
    public function beSendApiRequest($data = []){
        $ch = curl_init();
        $username = $data["data"]["login_username"];
        $password = $data["data"]["login_password"];
        $loginotken = base64_encode($username.":".$password);
        unset($data["data"]["login_username"]);
        unset($data["data"]["login_password"]);
        $url = "https://{$data['apiurl']}:8443/api/v2/{$data['endpoint']}";
        if(in_array($data["method"],["GET","DELETE"]) && $data["data"]){
            $url .= "?".http_build_query($data["data"]);
        }
        curl_setopt($ch,CURLOPT_URL,$url);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_CUSTOMREQUEST,$data["method"]);
        if(in_array($data["method"],["POST"]) && $data["data"]){
            curl_setopt($ch,CURLOPT_POSTFIELDS,json_encode($data["data"]));
        }
        curl_setopt($ch,CURLOPT_TIMEOUT,250);
        curl_setopt($ch,CURLOPT_HTTPHEADER,[
            "Content-Type: application/json",
            "Authorization: Basic {$loginotken}"
        ]);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
        $response = curl_exec($ch);
        $responsecode = curl_getinfo($ch,CURLINFO_HTTP_CODE);
        curl_close($ch);
        return ["responsecode" => $responsecode,"data" => json_decode($response,true)];
    }
}