<?php

namespace App\System\Module;
use App\System\Basic\beRouter;
use App\System\Model\PaymentModel;
use App\System\Model\SettingModel;
use App\System\Model\UserInfoModel;
use App\System\Vendor\Auth;

class paytr {
    public function paytr_info(){
        return [
            "name" => "PayTR",
            "description" => "PayTR ile ödeme almanızı sağlar",
            "version" => "1.2",
            "vercode" => 12,
            "author" => "ITenGriTR",
        ];
    }
    public function paytr_is_activated(){
        $settings = SettingModel::beGetSettings("paytr_status");
        return $settings["paytr_status"] == 1 ? true:false;
    }
    public function paytr_currency(){
        return 1;
    }
    public function paytr_template($params = []){
        $settings = SettingModel::beGetSettings("paytr_methodfee");
        $price = $params["total"];
        $currency = $params["currency"];
        $newprice = $price*(100+$settings["paytr_methodfee"])/100;
        return beGetView("global.paytr",["price" => round($newprice,2),"currency" => $currency]);
    }
    public function paytr_create_payment($invoice){
        $settings = SettingModel::beGetSettings("paytr_merchant_id,paytr_merchant_key,paytr_merchant_secret,paytr_methodfee");
        $user = Auth::beGetUser();
        $price = $invoice["itotal"];
        $invoice["ifee"] = round($price*$settings["paytr_methodfee"]/100,2);
        $price = $price*(100+$settings["paytr_methodfee"])/100;
        $price = round($price,2);
        $userinfo = UserInfoModel::beSelect("uiphone,uiaddress")->beWhere("uid",$user["uid"])->beGet();
        $merchant = [
            "id" => $settings["paytr_merchant_id"],
            "key" => $settings["paytr_merchant_key"],
            "salt" => $settings["paytr_merchant_secret"],
            "oid" => $invoice["oid"],
            "currency" => "TL"
        ];
        $payment = [
            "amount" => $price*100,
            "no_installment" => 0,
            "max_installment" => 0,
            "test_mode" => 0
        ];
        $user = [
            "email" => $user["email"],
            "ip" => beRouter::$beUserIP,
            "basket" => base64_encode(json_encode([
                $invoice["iname"],
                $invoice["itotal"],
                1
            ],JSON_UNESCAPED_UNICODE)),
            "name" => $user["name"]." ".$user["surname"],
            "adress" => $userinfo["uiaddress"],
            "phone" => $userinfo["uiphone"]
        ];
        if(!$user["adress"]){
            $user["adress"] = "Bilinmeyen adres bilgisi!";
        }
        $hash_str = $merchant["id"].$user["ip"].$merchant["oid"].$user["email"].$payment["amount"].$user["basket"].$payment["no_installment"].$payment["max_installment"].$merchant["currency"].$payment["test_mode"];
        $token = base64_encode(hash_hmac("sha256",$hash_str.$merchant["salt"],$merchant["key"],true));
        $post_vals = [
            "merchant_id" => $merchant["id"],
            "merchant_oid" => $merchant["oid"],
            "user_ip" => $user["ip"],
            "email" => $user["email"],
            "payment_amount" => $payment["amount"],
            "paytr_token" => $token,
            "user_basket" => $user["basket"],
            "debug_on" => 0,
            "no_installment" => $payment["no_installment"],
            "max_installment" => $payment["max_installment"],
            "user_name" => $user["name"],
            "user_address" => $user["adress"],
            "user_phone" => $user["phone"],
            "merchant_ok_url" => beGetRoute("client.dashboard"),
            "merchant_fail_url" => beGetRoute("client.invoice.invoices.unpaid"),
            "timeout_limit" => "5",
            "currency" => $merchant["currency"],
            "test_mode" => $payment["test_mode"]
        ];	
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,"https://www.paytr.com/odeme/api/get-token");
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch,CURLOPT_POST,1);
        curl_setopt($ch,CURLOPT_POSTFIELDS,$post_vals);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_IPRESOLVE,CURL_IPRESOLVE_V4);
        curl_setopt($ch,CURLOPT_TIMEOUT,10);
        $result = curl_exec($ch);
        if(curl_errno($ch)){
            return ["status" => false,"message" => "Bir sorun oluştu: ".curl_error($ch)."(".curl_errno($ch).")"];
        }
        $result = json_decode($result,true);
        if($result["status"] != "success"){
            return ["status" => false,"message" => "Ödeme oluştururlurken bir şeyler ters gitti".print_r($result,true)];
        }
        curl_close($ch);
        $payment = [
            "price" => $price,
            "token" => $result["token"]
        ];
        return [
            "status" => true,
            "payment" => $payment,
            "invoice" => $invoice,
            "message" => "Başarılı bir şekilde ödeme işleminiz oluşturuldu!",
            "url" => "https://www.paytr.com/odeme/guvenli/{$result['token']}"
        ];
    }
    public function paytr_pay_notification(){
        $settings = SettingModel::beGetSettings("paytr_merchant_key,paytr_merchant_secret");
        $hash = base64_encode(hash_hmac("sha256",$_POST["merchant_oid"].$settings["paytr_merchant_secret"].$_POST["status"].$_POST["total_amount"],$settings["paytr_merchant_key"],true));
        if($hash != $_POST["hash"]){
            return ["status" => false,"message" => "Token doğrulamadı lütfen sistemi kontrol edin!"];
        }
        $oid = $_POST["merchant_oid"];
        $payment = PaymentModel::beSelect("pid,cid,uid,iid,ptotal,pstatus")->beWhere("pid",$oid)->beGet();
        if(!$payment){
            return ["status" => false,"message" => "OK"];
        }
        if($payment["pstatus"] != 0){
            PaymentModel::beUpdate(["pstatus" => "-1"])->beWhere("pid",$payment["pid"])->beExecute();
            return ["status" => false,"message" => "OK"];
        }
        if($_POST["status"] != "success"){
            PaymentModel::beUpdate(["pstatus" => "-1"])->beWhere("pid",$payment["pid"])->beExecute();
            return ["status" => false,"message" => "OK"];
        }
        PaymentModel::beUpdate(["pstatus" => "1"])->beWhere("pid",$payment["pid"])->beExecute();
        return ["status" => true,"payment" => $payment,"add_accounting" => true,"message" => "OK"];
    }
}
?>