<?php

namespace App\System\Module;

use App\System\Basic\beModel;
use App\System\Model\AttachmentModel;
use App\System\Model\CurrencyModel;
use App\System\Model\InvoiceModel;
use App\System\Model\ModuleLogModel;
use App\System\Model\SettingModel;
use App\System\Vendor\Auth;
use App\System\Vendor\beLanguage;
use App\System\Vendor\bePlugin;
use App\System\Vendor\beUpload;
use Error;

class cari {
    public function cari_info(){
        return [
            "name" => "Cari Fatura Resmileştirme",
            "description" => "Sistem üzerinden yapılan satım alımları resmileştirir",
            "version" => "1.0",
            "vercode" => 10,
            "author" => "ITenGriTR"
        ];
    }
    public function cari_login(){
        $settings = SettingModel::beGetSettings("cari_email,cari_password,cari_data");
        $cari_data = json_decode($settings["cari_data"],true);
        if($cari_data["expiration"]){
            if($cari_data["expiration"] > BE_TIME){
                return ["status" => true,"message" => "Cari fatura entegrasyonuna ön bellek üzerinden başarılı bir şekilde bağlandı","token" => $cari_data["token"],"expiration" => $cari_data["expiration"]];
            }
        }
        $response = $this->beSendApiRequest([
            "method" => "login",
            "data" => [
                "email" => $settings["cari_email"],
                "password" => $settings["cari_password"],
            ]
        ]);
        if($response["status"] != "success"){
            return ["status" => false,"message" => $response["message"]];
        }
        $cari_data["token"] = $response["token"];
        $cari_data["expiration"] = $response["expiration"];
        SettingModel::beUpdate(["svalue" => json_encode($cari_data)])->beWhere("scode","cari_data")->beExecute();
        return ["status" => true,"message" => "Cari fatura entegrasyonuna başarılı bir şekilde bağlanıldı!","token" => $response["token"],"expiration" => $response["expiration"]];
    }
    public function cari_create_invoice($data = []){
        beLanguage::beReadLang("invoice");
        $token = $data["token"];
        $resettax = false;
        if($data["invoice"]["cid"] != 1){
            $data["invoice"]["iprice"] = beConvertCurrencie($data["invoice"]["iprice"],$data["invoice"]["cid"],1);
            $data["invoice"]["itaxprice"] = beConvertCurrencie($data["invoice"]["itaxprice"],$data["invoice"]["cid"],1);
        }
        $othercode = 0;
        if($data["userinfo"]["acid"] == 218){
            $useridentityplugin = bePlugin::beGetPlugin("useridentity");
            if(!$useridentityplugin["status"]){
                return beAjaxError(["message" => beGetLang("invoice_bill_useridentity_not_loaded")]);
            }
            $useridentity = beModel::beTable("be_user_identity")->beSelect("*")->beWhere("uid",$data["invoice"]["uid"])->beGet();
            if(!$useridentity){
                return beAjaxError(["message" => beGetLang("invoice_bill_empty_user_data")]);
            }
            $distric = beModel::beTable("be_address_district")->beSelect("adid,adname,adcode")->beWhere("adid",$useridentity["adid"])->beGet();
            $province = beModel::beTable("be_address_province")->beSelect("apid,apname")->beWhere("apid",$useridentity["apid"])->beGet();
        }
        else{
            $settings = SettingModel::beGetSettings("gib_global,gib_default_no");
            if($settings["gib_global"] == 0){
                return ["status" => false,"message" => "Belirtilen kullanıcının Türkiye'de kaydı bulunamıyor!"];
            }
            $distric["adname"] = "Adana";
            $province["apname"] = "Ceyhan";
            $useridentity["uiname"] = $data["user"]["name"];
            $useridentity["uisurname"] = $data["user"]["surname"];
            $useridentity["uitcno"] = $settings["gib_default_no"];
            $useridentity["uitype"] = 1;
            $data["invoice"]["itaxprice"] = 0;
            $othercode = 351;
            $resettax = true;
        }
        $quequename = strtoupper(str_replace(" ","",beGetConfig("siteshortname")));
        if(strlen($quequename) > 3){
            $quequename = substr($quequename,0,3);
        }
        $quequeno = strval($data["invoice"]["iid"]);
        $quequeno = date("Y",BE_TIME)."000000000";
        $iidstr = strval($data["invoice"]["iid"]);
        $iidlength = strlen($iidstr);
        for($i = 0; $i < $iidlength; $i++){
            $quequeno[13-$iidlength+$i] = $iidstr[$i];
        }
        switch($useridentity["uitype"]){
            case 1 :
                if(!$useridentity["uitcno"]){
                    return ["status" => false,"message" => "Belirtilen kullanıcının Türkiye'de kaydı bulunamıyor!"];
                }
                $requestdata = [
                    "fatura" => [
                        "fatura_id" => $data["invoice"]["iid"],
                        "aciklama" => "",
                        "tarih" => date("d.m.Y",$data["datetime"]),
                        "saat" => date("H:m:s",$data["datetime"]),
                        "vade_tarihi" => "",
                        "seri_no" => $quequename,
                        "istisna_kod" => $othercode,
                        "ara_toplam_tutar" => number_format($data["invoice"]["iprice"],2,".",""),
                        "toplam_kdv_tutari" => number_format($data["invoice"]["itaxprice"],2,".",""),
                        "genel_toplam_tutar" => number_format($data["invoice"]["iprice"]+$data["invoice"]["itaxprice"],2,".","")
                    ],
                    "musteri" => [
                        "unvan" => "",
                        "ad_soyad" => $useridentity["uiname"]." ".$useridentity["uisurname"],
                        "tc_vergi_no" => $useridentity["uitcno"],
                        "vergi_dairesi" => "",
                        "telefon" => $data["userinfo"]["uiphone"],
                        "email" => $data["user"]["email"],
                        "adres" => $data["userinfo"]["uiaddress"],
                        "il_baslik" => $distric["adname"],
                        "ilce_baslik" => $province["apname"]
                    ]
                ];
                break;
            case 2 :
                if(!$useridentity["uitaxno"]){
                    return ["status" => false,"message" => "Belirtilen kullanıcının Türkiye'de kaydı bulunamıyor!"];
                }
                $requestdata = [
                    "fatura" => [
                        "fatura_id" => $data["invoice"]["iid"],
                        "aciklama" => "",
                        "tarih" => date("d.m.Y",$data["datetime"]),
                        "saat" => date("H:m:s",$data["datetime"]),
                        "vade_tarihi" => "",
                        "seri_no" => $quequename,
                        "istisna_kod" => $othercode,
                        "ara_toplam_tutar" => number_format($data["invoice"]["iprice"],2,".",""),
                        "toplam_kdv_tutari" => number_format($data["invoice"]["itaxprice"],2,".",""),
                        "genel_toplam_tutar" => number_format($data["invoice"]["iprice"]+$data["invoice"]["itaxprice"],2,".","")
                    ],
                    "musteri" => [
                        "unvan" => $useridentity["uititle"],
                        "ad_soyad" => "",
                        "tc_vergi_no" => $useridentity["uitaxno"],
                        "vergi_dairesi" => $useridentity["uitaxadmin"],
                        "telefon" => $data["userinfo"]["uiphone"],
                        "email" => $data["user"]["email"],
                        "adres" => $data["userinfo"]["uiaddress"],
                        "il_baslik" => $distric["adname"],
                        "ilce_baslik" => $province["apname"]
                    ]
                ];
                break;
        }
        foreach($data["invoiceitems"] as $item){
            if($item["cid"] != 1){
                $item["iiunitprice"] = beConvertCurrencie($item["iiunitprice"],(int)$item["cid"],1);
            }
            $itemprice = $item["iiunitprice"];
            if(!$resettax){
                $itemtax = round($itemprice*$item["iitaxrate"]/100,2);
            }
            else{
                $itemtax = 0; 
                $item["iitaxrate"] = 0;
            }
            if(preg_match('/(.*)\((.*)\)/',$item["iiname"],$basketdata)){
                $requestdata["urunler"][] = [
                    "urun_baslik" => $basketdata[1],
                    "kdvsiz_tutar" => $itemprice,
                    "kdv_yuzde" => $item["iitaxrate"],
                    "kdvli_tutar" => $itemprice+$itemtax,
                    "adet" => $item["iiunitcount"],
                ];
                $requestdata["fatura"]["aciklama"] .= $basketdata[1].":".$basketdata[2]."\n";
            }
            else{
                $requestdata["urunler"][] = [
                    "urun_baslik" => $item["iiname"],
                    "kdvsiz_tutar" => $itemprice,
                    "kdv_yuzde" => $item["iitaxrate"],
                    "kdvli_tutar" => $itemprice+$itemtax,
                    "adet" => $item["iiunitcount"],
                ];
            }
        }
        $response = $this->beSendApiRequest([
            "method" => "create_invoice",
            "data" => [
                "token" => $token,
                "invoicedata" => $requestdata
            ]
        ]);
        $invoiceno = $response["invoiceno"];
        if($response["status"] != "success" && $response["code"] != 42){
            ModuleLogModel::beCreateModuleLog(0,"cari","Fatura Oluşturma Hatası","Fatura oluşturma esnasında bir sorun oluştu! Dönen hata: ".$response["message"],[
                "requestdata" => $requestdata,
                "response" => $response
            ]);
            return ["status" => false,"message" => "Fatura oluşturma esnasında bir sorun oluştu!"];
        }
        $response = $this->beSendApiRequest([
            "method" => "invoice_set_official",
            "data" => [
                "token" => $token,
                "invoiceno" => $invoiceno
            ]
        ]);
        if($response["status"] != "success"){
            ModuleLogModel::beCreateModuleLog(0,"cari","Fatura Resmileştirme Hatası","Fatura oluşturuldu fakat resmileştirilirken bir sorun oluştu! Dönen hata: ".$response["message"],[
                "requestdata" => [
                    "token" => $token,
                    "invoiceno" => $invoiceno,
                ],
                "response" => $response
            ]);
            return ["status" => false,"message" => "Fatura oluşturuldu fakat resmileştirilmesi esnasında bir sorun oluştu!"];
        }
        $filename = substr(md5(BE_TIME),0,8)."-".substr(md5($data["invoice"]["iid"]),0,8);
        $filecontent = file_get_contents($response["pdfurl"]);
        $upload = beUpload::beSetSpecialFile($filename,$filecontent,BE_APPPATH."resources/upload/invoice");
        if($upload["status"]){
            $slug = beSelfLink($upload["filename"]);
            $aid = AttachmentModel::beInsert([
                "uid" => $data["invoice"]["uid"],
                "aname" => $upload["filename"],
                "aslug" => $slug,
                "atype" => "application/pdf",
                "asize" => $upload["size"],
                "apath" => "resources/upload/invoice/".$upload["realname"],
                "aviews" => 0,
                "adownloads" => 0,
                "astatus" => "1",
                "afavorite" => "0",
                "apassword" => "",
                "adateline" => BE_TIME
            ]);
            return ["status" => true,"invoicedata" => [
                "ibilldata" => json_encode([
                    "aid" => $aid,
                    "invoiceno" => $invoiceno   
                ],JSON_UNESCAPED_UNICODE),
                "ibill" => 1
            ]];
        }
        else{
            return ["status" => true,"invoicedata" => [
                "ibilldata" => json_encode([
                    "invoiceno" => $invoiceno   
                ],JSON_UNESCAPED_UNICODE)
            ]];
        }
    }
    public function cari_get_invoice($data = []){
        $response = $this->beSendApiRequest([
            "method" => "invoice_set_official",
            "data" => [
                "token" => $data["token"],
                "invoiceno" => $data["invoiceno"],
            ]
        ]);
        if($response["status"] != "success"){
            return ["status" => false,"message" => "Fatura PDF dosyası çekilirken bir sorun oluştu lütfen kontrol ediniz!"];
        }
        $filecontent = $response["pdfdata"];
        return ["status" => true,"pdf_data" => $filecontent];
    }
    public function beSendApiRequest($data = []){
        global $be;
        $settings = $be->settings;
        $data["data"] = array_merge($data["data"],[
            "cid" => $settings["system_id"],
            "ctoken" => $settings["system_token"],
            "secret" => $settings["system_secret"],
            "acces_token" => substr(md5($settings["system_id"].BE_TIME),0,8),
            "time" => BE_TIME
        ]);
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,"https://".$be->settings["system_data"]["api"]["active"]."/api/cari/{$data['method']}");
        curl_setopt($ch,CURLOPT_POST,1);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query($data["data"]));
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch,CURLOPT_TIMEOUT,250);
        $response = curl_exec($ch);
        curl_close($ch);
        return json_decode($response,true);
    }
}
?>