<?php

namespace App\System\Controller;

use App\System\Basic\beCache;
use App\System\Basic\beContoller;
use App\System\Model\SettingModel;
use App\System\Model\TaskModel;
use App\System\Model\ThemeModel;
use App\System\Vendor\beLanguage;
use App\System\Vendor\beTask;

class TaskController extends beContoller {
    public function list(){
        $tasks = TaskModel::beGetAll();
        $lastcron = 0;
        foreach($tasks as $task){
            if($task["tlastruntime"] > $lastcron){
                $lastcron = (int)$task["tlastruntime"];
            }
        }
        return beGetView("admin.task.list",["tasks" => $tasks,"lastcron" => $lastcron]);
    }
    public function add(){
        return beGetView("admin.task.add");
    }
    public function add_post(){
        beLanguage::beReadLang("task");
        beLanguage::beReadLang("form");
        if(!$_POST["tname"] || !in_array((int)$_POST["tlogs"],[0,1]) || !in_array((int)$_POST["tstatus"],[0,1])){
            return beAjaxError(["message" => beGetLang("form_not_full")]);
        }
        if($_POST["tcronminute"] != "*"){
            if(!preg_match("/^[0-9]+$/",str_replace(",","",$_POST["tcronminute"]))){
                return beAjaxError(["message" => beGetLang("task_cron_error")]);
            }
        }
        if($_POST["tcronhour"] != "*"){
            if(!preg_match("/^[0-9]+$/",str_replace(",","",$_POST["tcronhour"]))){
                return beAjaxError(["message" => beGetLang("task_cron_error")]);
            }
        }
        if($_POST["tcronday"] != "*"){
            if(!preg_match("/^[0-9]+$/",str_replace(",","",$_POST["tcronday"]))){
                return beAjaxError(["message" => beGetLang("task_cron_error")]);
            }
        }
        $file = BE_APPPATH."tasks/{$_POST['tfilename']}.php";
        if(!file_exists($file)){
            return beAjaxError(["message" => beGetLang("task_cron_file_not_found")]);
        }
        $tid = TaskModel::beInsert([
            "tname" => $_POST["tname"],
            "tfilename" => $_POST["tfilename"],
            "tqueque" => (int)$_POST["tqueque"],
            "tcronminute" => $_POST["tcronminute"],
            "tcronhour" => $_POST["tcronhour"],
            "tcronday" => $_POST["tcronday"],
            "tlogs" => $_POST["tlogs"],
            "tstatus" => $_POST["tstatus"],
            "tlastruntime" => 0,
            "tnextruntime" => 0,
            "tlocktime" => 0,
            "tdateline" => BE_TIME
        ]);
        return beAjaxSuccess(["message" => beGetLang("task_created"),"url" => beGetRoute("admin.task.edit",["tid" => $tid])]);
    }
    public function edit($tid){
        beLanguage::beReadLang("task");
        $task = TaskModel::beWhere("tid",$tid)->beGet();
        if(!$task){
            beError(beGetLang("task"),beGetLang("task_not_found"));
        }
        return beGetView("admin.task.edit",["task" => $task]);
    }
    public function edit_post(){
        beLanguage::beReadLang("task");
        beLanguage::beReadLang("form");
        $tid = (int)$_POST["tid"];
        $task = TaskModel::beSelect("tid,tstatus")->beWhere("tid",$tid)->beGet();
        if(!$task){
            return beAjaxError(["message" => beGetLang("task_not_found")]);
        }
        if(!$_POST["tname"] || !in_array((int)$_POST["tlogs"],[0,1]) || !in_array((int)$_POST["tstatus"],[0,1])){
            return beAjaxError(["message" => beGetLang("form_not_full")]);
        }
        if($_POST["tcronminute"] != "*"){
            if(!preg_match("/^[0-9]+$/",str_replace(",","",$_POST["tcronminute"]))){
                return beAjaxError(["message" => beGetLang("task_cron_error")]);
            }
        }
        if($_POST["tcronhour"] != "*"){
            if(!preg_match("/^[0-9]+$/",str_replace(",","",$_POST["tcronhour"]))){
                return beAjaxError(["message" => beGetLang("task_cron_error")]);
            }
        }
        if($_POST["tcronday"] != "*"){
            if(!preg_match("/^[0-9]+$/",str_replace(",","",$_POST["tcronday"]))){
                return beAjaxError(["message" => beGetLang("task_cron_error")]);
            }
        }
        $file = BE_APPPATH."tasks/{$_POST['tfilename']}.php";
        if(!file_exists($file)){
            return beAjaxError(["message" => beGetLang("task_cron_file_not_found")]);
        }
        TaskModel::beUpdate([
            "tname" => $_POST["tname"],
            "tfilename" => $_POST["tfilename"],
            "tqueque" => (int)$_POST["tqueque"],
            "tcronminute" => $_POST["tcronminute"],
            "tcronhour" => $_POST["tcronhour"],
            "tcronday" => $_POST["tcronday"],
            "tlogs" => $_POST["tlogs"],
            "tstatus" => $_POST["tstatus"],
        ])->beWhere("tid",$task["tid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("task_updated")]);
    }
    public function status_post(){
        beLanguage::beReadLang("task");
        $tid = (int)$_POST["tid"];
        $task = TaskModel::beSelect("tid,tstatus")->beWhere("tid",$tid)->beGet();
        if(!$task){
            return beAjaxError(["message" => beGetLang("task_not_found")]);
        }
        $status = "1";
        if($task["tstatus"] == "1"){
            $status = "0";
        }
        $html = '<span class="badge '.($status == 1 ? "badge-success":"badge-danger").'">'.($status == 1 ? "Aktif":"Pasif").'</span>';
        TaskModel::beUpdate(["tstatus" => $status])->beWhere("tid",$task["tid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("task_updated"),"html" => $html]);
    }
    public function execute_post(){
        beLanguage::beReadLang("task");
        $tid = (int)$_POST["tid"];
        $task = TaskModel::beSelect("tid,tfilename")->beWhere("tid",$tid)->beGet();
        if(!$task){
            return beAjaxError(["message" => beGetLang("task_not_found")]);
        }
        beTask::beRunTask($task);
        return beAjaxSuccess(["message" => beGetLang("task_executed")]);
    }
    public function delete_post(){
        beLanguage::beReadLang("task");
        $tid = (int)$_POST["tid"];
        $task = TaskModel::beSelect("tid")->beWhere("tid",$tid)->beGet();
        if(!$task){
            return beAjaxError(["message" => beGetLang("task_not_found")]);
        }
        TaskModel::beDelete()->beWhere("tid",$task["tid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("task_deleted")]);
    }
}

?>