<?php

namespace App\System\Controller;

use App\System\Basic\beCache;
use App\System\Basic\beContoller;
use App\System\Model\AttachmentModel;
use App\System\Model\LanguageModel;
use App\System\Model\MenuModel;
use App\System\Vendor\Auth;
use App\System\Vendor\beLanguage;
use App\System\Vendor\beUpload;

class MenuController extends beContoller {
    //@ioncube.dk beEncrypt("be_diyocp","list") -> "9101db8b3142404cffbb15d98d4e633a" RANDOM
    public function list(){
        $menutypes = MenuModel::beGetMenuTypes();
        $languages = LanguageModel::beGetLanguages("lid,lname");
        return beGetView("admin.menu.list",["menutypes" => $menutypes,"languages" => $languages]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","add") -> "693124c9e83f454f57d2e4f611fe1c9c" RANDOM
    public function add(){
        global $be;
        $systemlid = $be->settings["system_language"];
        $menutypes = MenuModel::beGetMenuTypes();
        $menupositions = MenuModel::beGetMenuPositions();
        $menustatus = MenuModel::beGetMenuStatus();
        $languages = LanguageModel::beGetLanguages("lid,lname");
        $uppermenus = MenuModel::beSelect("mid,mname")->beWhere("pid",0)->beWhere("mtype","menu")->beGetAll();
        return beGetView("admin.menu.add",["menutypes" => $menutypes,"menupositions" => $menupositions,"menustatus" => $menustatus,"languages" => $languages,"uppermenus" => $uppermenus,"systemlid" => $systemlid]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","add_post") -> "ffadff297f0a97a2330891c534e5ce93" RANDOM
    public function add_post(){
        beLanguage::beReadLang("menu");
        beLanguage::beReadLang("language");
        $mainmenu = (int)$_POST["mainmenu"];
        $type = $_POST["type"];
        $position = $_POST["position"];
        $lid = (int)$_POST["language"];
        $name = $_POST["name"];
        $altname = $_POST["altname"];
        $description = $_POST["description"];
        $icon = $_POST["icon"];
        $queque = (int)$_POST["queque"];
        $route = $_POST["route"];
        $adversiment = $_POST["adversiment"];
        $status = $_POST["status"];
        $menutypes = MenuModel::beGetMenuTypes();
        $menupositions = MenuModel::beGetMenuPositions();
        $menustatus = MenuModel::beGetMenuStatus();
        if(!$menutypes[$type] || !$menupositions[$position] || !$menustatus[$status]){
            return beAjaxError(["message" => beGetLang("menu_position_not_correct")]);
        }
        $language = LanguageModel::beGetLanguages("lid",$lid);
        if(!$language){
            return beAjaxError(["message" => beGetLang("language_not_found")]);
        }
        $adversimentdata = [];
        if($adversiment["name"]){
            $adversimentdata["name"] = $adversiment["name"];
            $adversimentdata["class"] = $adversiment["class"];
        }
        MenuModel::beInsert([
            "lid" => $language["lid"],
            "pid" => $mainmenu,
            "mtype" => $type,
            "mposition" => $position,
            "micon" => $icon,
            "mname" => $name,
            "maltname" => $altname,
            "mdescription" => $description,
            "madversiment" => $adversimentdata ? (json_encode($adversimentdata,JSON_UNESCAPED_UNICODE)):"",
            "mqueque" => $queque,
            "mroute" => $route,
            "mstatus" => $status,
            "mdateline" => BE_TIME
        ]);
        $this->beRenderMenus();
        return beAjaxSuccess(["message" => beGetLang("menu_created")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","edit") -> "ef2c86a2f570e9f43db63597a17bf569" RANDOM
    public function edit($mid){
        beLanguage::beReadLang("menu");
        $menu = MenuModel::beWhere("mid",$mid)->beGet();
        if(!$menu){
            beError(beGetLang("menu"),beGetLang("menu_not_found"));
        }
        $menutypes = MenuModel::beGetMenuTypes();
        $menupositions = MenuModel::beGetMenuPositions();
        $menustatus = MenuModel::beGetMenuStatus();
        $languages = LanguageModel::beGetLanguages("lid,lname");
        if($menu["mtype"] == "menu"){
            $menu["altmenus"] = MenuModel::beWhere("pid",$menu["mid"])->beGetAll();
        }
        if($menu["mtype"] != "menu"){
            $menu["uppermenus"] = MenuModel::beSelect("mid,mname")->beWhere("lid",$menu["lid"])->beWhere("pid",0)->beWhere("mtype","menu")->beGetAll();
        }
        return beGetView("admin.menu.edit",["menu" => $menu,"menutypes" => $menutypes,"menupositions" => $menupositions,"menustatus" => $menustatus,"languages" => $languages]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","edit_post") -> "612153cbfbd9f0b9015947cac84fe756" RANDOM
    public function edit_post(){
        beLanguage::beReadLang("menu");
        beLanguage::beReadLang("language");
        $mid = (int)$_POST["mid"];
        $mainmenu = (int)$_POST["mainmenu"];
        $type = $_POST["type"];
        $position = $_POST["position"];
        $lid = (int)$_POST["language"];
        $name = $_POST["name"];
        $altname = $_POST["altname"];
        $description = $_POST["description"];
        $icon = $_POST["icon"];
        $queque = (int)$_POST["queque"];
        $route = $_POST["route"];
        $adversiment = $_POST["adversiment"];
        $status = $_POST["status"];
        $menu = MenuModel::beSelect("mid")->beWhere("mid",$mid)->beGet();
        if(!$menu){
            return beAjaxError(["message" => beGetLang("menu_not_found")]);
        }
        $menutypes = MenuModel::beGetMenuTypes();
        $menupositions = MenuModel::beGetMenuPositions();
        $menustatus = MenuModel::beGetMenuStatus();
        if(!$menutypes[$type] || !$menupositions[$position] || !$menustatus[$status]){
            return beAjaxError(["message" => beGetLang("menu_position_not_correct")]);
        }
        $language = LanguageModel::beGetLanguages("lid",$lid);
        if(!$language){
            return beAjaxError(["message" => beGetLang("language_not_found")]);
        }
        $adversimentdata = [];
        if($adversiment["name"]){
            $adversimentdata["name"] = $adversiment["name"];
            $adversimentdata["class"] = $adversiment["class"];
        }
        MenuModel::beUpdate([
            "lid" => $language["lid"],
            "pid" => $mainmenu,
            "mtype" => $type,
            "mposition" => $position,
            "micon" => $icon,
            "mname" => $name,
            "maltname" => $altname,
            "mdescription" => $description,
            "madversiment" => $adversimentdata ? (json_encode($adversimentdata,JSON_UNESCAPED_UNICODE)):"",
            "mqueque" => $queque,
            "mroute" => $route,
            "mstatus" => $status,
        ])->beWhere("mid",$menu["mid"])->beExecute();
        $this->beRenderMenus();
        return beAjaxSuccess(["message" => beGetLang("menu_updated")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","delete_post") -> "f2e13f17daf43cb049e56f8ccb4e3d39" RANDOM
    public function delete_post(){
        beLanguage::beReadLang("menu");
        $mid = (int)$_POST["mid"];
        $menu = MenuModel::beSelect("mid")->beWhere("mid",$mid)->beGet();
        if(!$menu){
            return beAjaxError(["message" => beGetLang("menu_not_found")]);
        }
        MenuModel::beDelete()->beWhere("mid",$menu["mid"])->beExecute();
        MenuModel::beUpdate(["pid" => 0])->beWhere("pid",$menu["mid"])->beExecute();
        $this->beRenderMenus();
        return beAjaxSuccess(["message" => beGetLang("menu_deleted")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","beRenderMenus") -> "ed6fd1a944087bddc7f321c3cfa16f37" RANDOM
    private function beRenderMenus(){
        $languages = LanguageModel::beGetLanguages("lid");
        foreach($languages as $language){
            $menus = [];
            $menulist = MenuModel::beWhere("lid",$language["lid"])->beWhere("mstatus","1")->beOrder("mqueque","ASC")->beGetAll();
            foreach($menulist as $menu){
                if(substr($menu["mroute"],0,4) != "http"){
                    $menu["mroute"] = beGetRoute($menu["mroute"]);
                }
                switch($menu["mtype"]){
                    case "url" :
                        if($menu["mposition"] == "all"){
                            $menus["header"][] = [
                                "type" => "url",	
                                "name" => $menu["mname"],	
                                "altname" => $menu["maltname"],	
                                "description" => $menu["mdescription"],	
                                "adversiment" => json_decode($menu["madversiment"],true),
                                "url" => $menu["mroute"]
                            ];
                            $menus["footer"][] = [
                                "type" => "url",	
                                "name" => $menu["mname"],	
                                "altname" => $menu["maltname"],	
                                "description" => $menu["mdescription"],	
                                "adversiment" => json_decode($menu["madversiment"],true),
                                "url" => $menu["mroute"]
                            ];
                        }
                        else{
                            $menus[$menu["mposition"]][] = [
                                "type" => "url",	
                                "name" => $menu["mname"],	
                                "altname" => $menu["maltname"],	
                                "description" => $menu["mdescription"],
                                "adversiment" => json_decode($menu["madversiment"],true),
                                "url" => $menu["mroute"]
                            ];
                        }
                        break;
                    case "menu" :
                        $altmenusspecial = [];
                        foreach($menulist as $altmenu){
                            if($altmenu["pid"] == $menu["mid"] && $altmenu["mtype"] == "altmenu"){
                                if(substr($altmenu["mroute"],0,4) != "http"){
                                    $altmenu["mroute"] = beGetRoute($altmenu["mroute"]);
                                }
                                if($altmenu["mposition"] == "all"){
                                    $altmenusspecial["header"][] = [
                                        "icon" => $altmenu["micon"],	
                                        "name" => $altmenu["mname"],	
                                        "altname" => $altmenu["maltname"],	
                                        "description" => $altmenu["mdescription"],
                                        "adversiment" => json_decode($menu["madversiment"],true),
                                        "url" => $altmenu["mroute"]
                                    ];  
                                    $altmenusspecial["footer"][] = [
                                        "icon" => $altmenu["micon"],	
                                        "name" => $altmenu["mname"],	
                                        "altname" => $altmenu["maltname"],	
                                        "description" => $altmenu["mdescription"],
                                        "adversiment" => json_decode($menu["madversiment"],true),
                                        "url" => $altmenu["mroute"]
                                    ];  
                                }
                                else{
                                    $altmenusspecial[$altmenu["mposition"]][] = [
                                        "icon" => $altmenu["micon"],	
                                        "name" => $altmenu["mname"],	
                                        "altname" => $altmenu["maltname"],	
                                        "description" => $altmenu["mdescription"],
                                        "adversiment" => json_decode($menu["madversiment"],true),
                                        "url" => $altmenu["mroute"]
                                    ];   
                                }
                            }
                        }
                        if($menu["mposition"] == "all"){
                            $menus["header"][] = [
                                "type" => "menu",	
                                "name" => $menu["mname"],	
                                "altname" => $menu["maltname"],	
                                "description" => $menu["mdescription"],
                                "adversiment" => json_decode($menu["madversiment"],true),
                                "altmenus" => $altmenusspecial["header"]
                            ];
                            $menus["footer"][] = [
                                "type" => "menu",	
                                "name" => $menu["mname"],	
                                "altname" => $menu["maltname"],	
                                "description" => $menu["mdescription"],
                                "adversiment" => json_decode($menu["madversiment"],true),
                                "altmenus" => $altmenusspecial["footer"]
                            ];
                        }
                        else{
                            $menus[$menu["mposition"]][] = [
                                "type" => "menu",	
                                "name" => $menu["mname"],	
                                "altname" => $menu["maltname"],	
                                "description" => $menu["mdescription"],
                                "adversiment" => json_decode($menu["madversiment"],true),
                                "altmenus" => array_merge($altmenusspecial["header"],$altmenusspecial["footer"])
                            ];
                        }
                        break;
                }
            }
            beCache::beSetCache("menus".$language["lid"],json_encode($menus,JSON_UNESCAPED_UNICODE));
        }
    }
    //@ioncube.dk beEncrypt("be_diyocp","search_post") -> "86c60ec2ca926334438a4ae77fc2cdaa" RANDOM
    public function search_post(){
        $sort = (int)$_POST["sort"];
        if(!$sort){
            $sort = 1;
        }
        $page = (int)$_POST["page"];
        if(!$page){
            $page = 1;
        }
        $name = $_POST["name"];
        $type = $_POST["type"];
        $lid = (int)$_POST["language"];
        if(!$lid){
            $user = Auth::beGetUser();
            $lid = $user["lid"];
        }
        $itemsearch = MenuModel::beSelect("COUNT(mid) as total");
        if($name){
            $itemsearch = $itemsearch->beWhere("mname",$name);
        }
        if($type != "0"){
            $itemsearch = $itemsearch->beWhere("mtype",$type);
        }
        if($lid){
            $itemsearch = $itemsearch->beWhere("lid",$lid);
        }
        $itemcount = (int)$itemsearch->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,"");
        $items = MenuModel::beSelect("*");
        if($name){
            $items = $items->beWhere("mname",$name);
        }
        if($type != "0"){
            $items = $items->beWhere("mtype",$type);
        }
        if($lid){
            $items = $items->beWhere("lid",$lid);
        }
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $orderkey = "mid";
        switch($sort){
            case 1 :
                $items = $items->beOrder($orderkey,"DESC");
                break;
            case 2 :
                $items = $items->beOrder($orderkey,"ASC");
                break;
        }
        $items = $items->beGetAll();
        $menutypes = MenuModel::beGetMenuTypes();
        $menustatus = MenuModel::beGetMenuStatus();
        $languages = LanguageModel::beGetLanguages("lid,lname");
        $itemhtml = beGetView("admin.menu.listrows",["items" => $items,"menutypes" => $menutypes,"menustatus" => $menustatus,"languages" => $languages]);
        return beAjaxSuccess(["html" => $itemhtml,"paganation" => $paganation["paganation"],"itemcount" => $itemcount]);
    }
}

?>