<?php

namespace App\System\Controller;
use App\System\Basic\beContoller;
use App\System\Basic\beModel;
use App\System\Vendor\Auth;
use App\System\Vendor\beLanguage;

class LogController extends beContoller {
    //@ioncube.dk beEncrypt("be_diyocp","system") -> "c38065db348bec8d5d9cea88fbe4c37a" RANDOM
    public function system(){
        return beGetView("admin.log.system.list");
    }
    //@ioncube.dk beEncrypt("be_diyocp","system_delete_post") -> "25865422d34660e66ad8abdf8357abee" RANDOM
    public function system_delete_post(){
        beLanguage::beReadLang("log");
        beModel::beQuery("TRUNCATE TABLE be_system_logs")->beExecute();
        return beAjaxSuccess(["message" => beGetLang("log_deleted")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","system_search_post") -> "606f6fa107d841d62977890018ce56a7" RANDOM
    public function system_search_post(){
        $sort = (int)$_POST["sort"];
        if(!$sort){
            $sort = 1;
        }
        $page = (int)$_POST["page"];
        if(!$page){
            $page = 1;
        }
        $user = (int)$_POST["user"];
        $itemsearch = beModel::beTable("be_system_logs")->beSelect("COUNT(slid) as total");
        if($user){
            $itemsearch = $itemsearch->beWhere("uid",$user);
        }
        $itemcount = (int)$itemsearch->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,"");
        $items = beModel::beTable("be_system_logs as sl")->beSelect("sl.*,u.name,u.surname");
        if($user){
            $items = $items->beWhere("sl.uid",$user);
        }
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $orderkey = "slid";
        switch($sort){
            case 1 :
                $items = $items->beOrder($orderkey,"DESC");
                break;
            case 2 :
                $items = $items->beOrder($orderkey,"ASC");
                break;
        }
        $items = $items->beJoin("LEFT JOIN be_users as u ON u.uid = sl.uid")->beGetAll();
        $itemhtml = beGetView("admin.log.system.listrows",["items" => $items]);
        return beAjaxSuccess(["html" => $itemhtml,"paganation" => $paganation["paganation"],"itemcount" => $itemcount]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","module") -> "1c82e3e05fc953d4a404fc94ff4f0783" RANDOM
    public function module(){
        return beGetView("admin.log.module.list");
    }
    //@ioncube.dk beEncrypt("be_diyocp","module_delete_post") -> "43f201e6d64adbc113fa2eb86c46b0a1" RANDOM
    public function module_delete_post(){
        beLanguage::beReadLang("log");
        beModel::beQuery("TRUNCATE TABLE be_module_logs")->beExecute();
        return beAjaxSuccess(["message" => beGetLang("log_deleted")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","module_search_post") -> "f9bd8e585e6d7cdce87a84e7228e67c0" RANDOM
    public function module_search_post(){
        $sort = (int)$_POST["sort"];
        if(!$sort){
            $sort = 1;
        }
        $page = (int)$_POST["page"];
        if(!$page){
            $page = 1;
        }
        $upid = (int)$_POST["upid"];
        $itemsearch = beModel::beTable("be_module_logs")->beSelect("COUNT(mlid) as total");
        if($upid){
            $itemsearch = $itemsearch->beWhere("upid",$upid);
        }
        $itemcount = (int)$itemsearch->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,"");
        $items = beModel::beTable("be_module_logs as ml")->beSelect("ml.*,up.upname,up.uptag");
        if($upid){
            $items = $items->beWhere("ml.upid",$upid);
        }
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $orderkey = "mlid";
        switch($sort){
            case 1 :
                $items = $items->beOrder($orderkey,"DESC");
                break;
            case 2 :
                $items = $items->beOrder($orderkey,"ASC");
                break;
        }
        $items = $items->beJoin("LEFT JOIN be_user_products as up ON up.upid = ml.upid")->beGetAll();
        $itemhtml = beGetView("admin.log.module.listrows",["items" => $items]);
        return beAjaxSuccess(["html" => $itemhtml,"paganation" => $paganation["paganation"],"itemcount" => $itemcount]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","user") -> "e9961ee257ac75a6881c7a11193bfa0d" RANDOM
    public function user(){
        return beGetView("admin.log.user.list");
    }
    //@ioncube.dk beEncrypt("be_diyocp","user_delete_post") -> "88601c667b621d9efa4db5945dd7291a" RANDOM
    public function user_delete_post(){
        beLanguage::beReadLang("log");
        beModel::beQuery("TRUNCATE TABLE be_user_logs")->beExecute();
        return beAjaxSuccess(["message" => beGetLang("log_deleted")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","user_search_post") -> "82b5f9db218ff3e871cc0c98e5aa415d" RANDOM
    public function user_search_post(){
        $sort = (int)$_POST["sort"];
        if(!$sort){
            $sort = 1;
        }
        $page = (int)$_POST["page"];
        if(!$page){
            $page = 1;
        }
        $user = (int)$_POST["user"];
        $itemsearch = beModel::beTable("be_user_logs")->beSelect("COUNT(lid) as total");
        if($user){
            $itemsearch = $itemsearch->beWhere("uid",$user);
        }
        $itemcount = (int)$itemsearch->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,"");
        $items = beModel::beTable("be_user_logs as ul")->beSelect("ul.*,u.name,u.surname");
        if($user){
            $items = $items->beWhere("ul.uid",$user);
        }
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $orderkey = "lid";
        switch($sort){
            case 1 :
                $items = $items->beOrder($orderkey,"DESC");
                break;
            case 2 :
                $items = $items->beOrder($orderkey,"ASC");
                break;
        }
        $items = $items->beJoin("LEFT JOIN be_users as u ON u.uid = ul.uid")->beGetAll();
        $usercontroller = new UserController();
        $admin = Auth::beGetUser();
        $usercontroller->beSetUserMessages($admin["lid"],$items);
        $itemhtml = beGetView("admin.log.user.listrows",["items" => $items]);
        return beAjaxSuccess(["html" => $itemhtml,"paganation" => $paganation["paganation"],"itemcount" => $itemcount]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","userproduct") -> "588f399e0a31dfe1d7202be704692797" RANDOM
    public function userproduct(){
        return beGetView("admin.log.userproduct.list");
    }
    //@ioncube.dk beEncrypt("be_diyocp","userproduct_delete_post") -> "0d0d0729703d7cdf9c8c29ad2384adc1" RANDOM
    public function userproduct_delete_post(){
        beLanguage::beReadLang("log");
        beModel::beQuery("TRUNCATE TABLE be_user_product_logs")->beExecute();
        return beAjaxSuccess(["message" => beGetLang("log_deleted")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","userproduct_search_post") -> "6287abad372a81104ec71207afe9ef36" RANDOM
    public function userproduct_search_post(){
        $sort = (int)$_POST["sort"];
        if(!$sort){
            $sort = 1;
        }
        $page = (int)$_POST["page"];
        if(!$page){
            $page = 1;
        }
        $user = (int)$_POST["user"];
        $upid = (int)$_POST["upid"];
        $itemsearch = beModel::beTable("be_user_product_logs")->beSelect("COUNT(uplid) as total");
        if($user){
            $itemsearch = $itemsearch->beWhere("uid",$user);
        }
        if($upid){
            $itemsearch = $itemsearch->beWhere("upid",$upid);
        }
        $itemcount = (int)$itemsearch->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,"");
        $items = beModel::beTable("be_user_product_logs as upl")->beSelect("upl.*,u.name,u.surname,up.upname,up.uptag");
        if($user){
            $items = $items->beWhere("upl.uid",$user);
        }
        if($upid){
            $items = $items->beWhere("upl.upid",$upid);
        }
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $orderkey = "uplid";
        switch($sort){
            case 1 :
                $items = $items->beOrder($orderkey,"DESC");
                break;
            case 2 :
                $items = $items->beOrder($orderkey,"ASC");
                break;
        }
        $items = $items->beJoin("LEFT JOIN be_users as u ON u.uid = upl.uid LEFT JOIN be_user_products as up ON up.upid = upl.upid")->beGetAll();
        $admin = Auth::beGetUser();
        $ordercontroller = new OrderController();
        $ordercontroller->beSetOrderMessages($admin["lid"],$items);
        $itemhtml = beGetView("admin.log.userproduct.listrows",["items" => $items]);
        return beAjaxSuccess(["html" => $itemhtml,"paganation" => $paganation["paganation"],"itemcount" => $itemcount]);
    }
}

?>