<?php

namespace App\System\Controller;

use App\System\Basic\beContoller;
use App\System\Basic\beModel;
use App\System\Model\LanguageModel;
use App\System\Model\SettingModel;
use App\System\Vendor\beLanguage;

class LanguageController extends beContoller {
    //@ioncube.dk beEncrypt("be_diyocp","list") -> "9101db8b3142404cffbb15d98d4e633a" RANDOM
    public function list(){
        $languages = LanguageModel::beSelect("lid,lname,lcode,ldateline")->beGetAll();
        return beGetView("admin.language.list",["languages" => $languages]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","add") -> "693124c9e83f454f57d2e4f611fe1c9c" RANDOM
    public function add(){
        return beGetView("admin.language.add");
    }
    //@ioncube.dk beEncrypt("be_diyocp","add_post") -> "ffadff297f0a97a2330891c534e5ce93" RANDOM
    public function add_post(){
        beLanguage::beReadLang("language");
        beLanguage::beReadLang("form");
        $name = $_POST["name"];
        $code = $_POST["code"];
        if(strlen($code) != 2){
            return beAjaxError(["message" => beGetLang("langugage_code_two_char")]);
        }
        if(empty($name)){
            return beAjaxError(["message" => beGetLang("form_not_full")]);
        }
        $newpath = BE_APPPATH."resources/languages/".$code;
        if(!mkdir($newpath,0777)){
            return beAjaxError(["message" => beGetLang("language_update_permission_denied")]);
        }
        shell_exec("cp -r ".BE_APPPATH."resources/languages/tr/* {$newpath}");
        LanguageModel::beInsert([
            "lname" => $name,
            "lcode" => $code,
            "lstatus" => "1",
            "ldateline" => BE_TIME
        ]);
        $this->editsetting();
        return beAjaxSuccess(["message" => beGetLang("language_created"),"url" => beGetRoute("admin.language.list")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","edit") -> "ef2c86a2f570e9f43db63597a17bf569" RANDOM
    public function edit($lid){
        beLanguage::beReadLang("language");
        $language = LanguageModel::beSelect("lid,lcode")->beWhere("lid",$lid)->beGet();
        if(!$language){
            beError(beGetLang("language"),beGetLang("language_not_found"));
        }
        $dir = BE_APPPATH."resources/languages/".$language["lcode"]."/";
        $editdata = [];
        foreach(glob($dir."*") as $file){
            $filename = str_replace([".lang.php",$dir],"",$file);
            beLanguage::beSetLanguage($language["lcode"]);
            $data = beLanguage::beReadLang($filename);
            $editdata[$filename] = [];
            foreach($data as $key => $val){
                $editdata[$filename][$key] = $val;
            }
        }
        return beGetView("admin.language.edit",["language" => $language,"editdata" => $editdata]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","edit_post") -> "612153cbfbd9f0b9015947cac84fe756" RANDOM
    public function edit_post(){
        beLanguage::beReadLang("language");
        $lid = (int)$_POST["lid"];
        $language = LanguageModel::beSelect("lid,lcode")->beWhere("lid",$lid)->beGet();
        if(!$language){
            return beAjaxError(["message" => beGetLang("language_not_found")]);
        }
        $dir = BE_APPPATH."resources/languages/".$language["lcode"]."/";
        foreach($_POST["lang"] as $filename => $data){
            $langtext = '<?php'.PHP_EOL.'return ['.PHP_EOL;
            foreach($data as $value){
                $langtext .= '"'.$value["key"].'" => "'.str_replace('"','\"',$value["val"]).'",'.PHP_EOL;
            }
            $langtext .= '];'.PHP_EOL.'?>';
            if(!file_put_contents($dir.$filename.".lang.php",$langtext)){
                return beAjaxError(["message" => beGetLang("language_update_permission_denied")]);
            }
        }
        return beAjaxSuccess(["message" => beGetLang("language_updated")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","edittext") -> "c43f72ce78d90d0beaa3b7c42e13b77e" RANDOM
    public function edittext($lid){
        beLanguage::beReadLang("language");
        $language = LanguageModel::beSelect("lid,lcode")->beWhere("lid",$lid)->beGet();
        if(!$language){
            beError(beGetLang("language"),beGetLang("language_not_found"));
        }
        $dir = BE_APPPATH."resources/languages/".$language["lcode"]."/";
        $editdata = [];
        foreach(glob($dir."*") as $file){
            $filename = str_replace([".lang.php",$dir],"",$file);
            $text = file_get_contents($file);
            $text = str_replace("<?php",">?php",$text);
            $text = str_replace("?>","?<",$text);
            $editdata[$filename] = $text;
        }
        return beGetView("admin.language.edittext",["language" => $language,"editdata" => $editdata]);
    }   
    //@ioncube.dk beEncrypt("be_diyocp","edittext_post") -> "07cd278f52b8814daf3c092c1a824ed8" RANDOM
    public function edittext_post(){
        beLanguage::beReadLang("language");
        $lid = (int)$_POST["lid"];
        $language = LanguageModel::beSelect("lid,lcode")->beWhere("lid",$lid)->beGet();
        if(!$language){
            return beAjaxError(["message" => beGetLang("language_not_found")]);
        }
        $dir = BE_APPPATH."resources/languages/".$language["lcode"]."/";
        foreach(glob($dir."*") as $file){
            $filename = str_replace([".lang.php",$dir],"",$file);
            $text = $_POST[$filename];
            $text = str_replace(">?php","<?php",$text);
            $text = str_replace("?<","?>",$text);
            if(!file_put_contents($file,$text)){
                return beAjaxError(["message" => beGetLang("language_update_permission_denied")]);
            }
        }
        return beAjaxSuccess(["message" => beGetLang("language_updated")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","editsetting") -> "0175cfe969c1c8e93429b691f105e434" RANDOM
    public function editsetting(){
        $languages = LanguageModel::beGetLanguages("lid,lname");
        $options = "select".PHP_EOL;
        foreach($languages as $language){
            $options .= $language["lid"]."=".$language["lname"].PHP_EOL;
        }
        $options = trim($options);
        SettingModel::beUpdate(["stype" => $options])->beWhere("scode","system_language")->beExecute();
    }
    //@ioncube.dk beEncrypt("be_diyocp","delete_post") -> "f2e13f17daf43cb049e56f8ccb4e3d39" RANDOM
    public function delete_post(){
        beLanguage::beReadLang("language");
        $lid = (int)$_POST["lid"];
        $language = LanguageModel::beSelect("lid")->beWhere("lid",$lid)->beGet();
        if(!$language){
            return beAjaxError(["message" => beGetLang("language_not_found")]);
        }
        LanguageModel::beDelete()->beWhere("lid",$language["lid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("language_deleted")]);
    }
}

?>