<?php

namespace App\System\Controller;
use App\System\Basic\beContoller;
use App\System\Model\SettingModel;

class ConnectionController extends beContoller {
    //@ioncube.dk beEncrypt("be_diyocp","beSendRequest") -> "02b69f21b821c317547a404fdfa7baae" RANDOM
    public static function beSendRequest($data = []){
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,"https://api.diyosoftware.com/api/global/{$data['method']}");
        curl_setopt($ch,CURLOPT_POST,1);
        curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query($data["data"]));
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch,CURLOPT_IPRESOLVE,CURL_IPRESOLVE_V4);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,0);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,0);
        $response = curl_exec($ch);
        curl_close($ch);
        return json_decode($response,true);
    }
    //@ioncube.dk beEncrypt("be_diyocp","beSendRequestControlPanel") -> "fe3d3a093b439715652cc022f609f647" RANDOM
    public static function beSendRequestControlPanel($data = []){
        $data["data"]["acces_token"] = substr(md5($data["data"]["cid"].BE_TIME),0,8);
        $data["data"]["time"] = BE_TIME;
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,self::beGetActiveApi()."/api/diyo-cp/{$data['method']}");
        curl_setopt($ch,CURLOPT_POST,1);
        curl_setopt($ch,CURLOPT_POSTFIELDS,["data" => self::beEncryptData(json_encode($data["data"],JSON_UNESCAPED_UNICODE),"diyosoftware-api/diyocp")]);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,0);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,0);
        $response = curl_exec($ch);
        $error = curl_errno($ch);
        curl_close($ch);
        if($error > 0 && !$data["notnext"]){
            self::beSelectNextApi();
            self::beSendRequest($data);
        }
        return json_decode($response,true);
    }
    //@ioncube.dk beEncrypt("be_diyocp","beSendRequestUpdate") -> "df2367a18b99eb2a8aca0426838bf055" RANDOM
    public static function beSendRequestUpdate($data = []){
        $data["data"]["acces_token"] = substr(md5($data["data"]["cid"].BE_TIME),0,8);
        $data["data"]["time"] = BE_TIME;
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,self::beGetActiveApi()."/api/update/{$data['method']}");
        curl_setopt($ch,CURLOPT_POST,1);
        curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query($data["data"]));
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,0);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,0);
        $response = curl_exec($ch);
        $error = curl_errno($ch);
        curl_close($ch);
        if($error > 0){
            self::beSelectNextApi();
            self::beSendRequest($data);
        }
        return json_decode($response,true);
    }
    //@ioncube.dk beEncrypt("be_diyocp","beSendRequestStore") -> "d0a7caae9a68a87c551835d3d57bd173" RANDOM
    public static function beSendRequestStore($data = []){
        $data["data"]["acces_token"] = substr(md5($data["data"]["cid"].BE_TIME),0,8);
        $data["data"]["time"] = BE_TIME;
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,self::beGetActiveApi()."/api/store/{$data['method']}");
        curl_setopt($ch,CURLOPT_POST,1);
        curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query($data["data"]));
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,0);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,0);
        $response = curl_exec($ch);
        $error = curl_errno($ch);
        curl_close($ch);
        if($error > 0){
            self::beSelectNextApi();
            self::beSendRequest($data);
        }
        return json_decode($response,true);
    }
    //@ioncube.dk beEncrypt("be_diyocp","beGetActiveApi") -> "4ac9dbbc65e38278ecb4be71aec76303" RANDOM
    public static function beGetActiveApi(){
        global $be;
        return "https://".$be->settings["system_data"]["api"]["active"];
    }
    //@ioncube.dk beEncrypt("be_diyocp","beSelectNextApi") -> "3e5269c77555baf66dc1f1b1e9cf546c" RANDOM
    public static function beSelectNextApi(){
        global $be;
        $list = $be->settings["system_data"]["api"]["list"];
        $active = $be->settings["system_data"]["api"]["active"];
        $lastkey = count($list);
        $activekey = array_search($active,$list);
        $activekey += 1;
        if($activekey > $lastkey-1){
            $activekey = 0;
        }
        $be->settings["system_data"]["api"]["active"] = $list[$activekey];
        SettingModel::beUpdate(["svalue" => json_encode($be->settings["system_data"],JSON_UNESCAPED_UNICODE)])->beWhere("scode","system_data")->beExecute();
    }
    //@ioncube.dk beEncrypt("be_diyocp","beEncryptData") -> "8909085a6007a20ca2c660c16e783230" RANDOM
    public static function beEncryptData($text = "",$key = ""){
        return openssl_encrypt($text,"AES-128-CBC",$key);
    }
    //@ioncube.dk beEncrypt("be_diyocp","beDecryptData") -> "0088de46f71eb164fc7db81f1cde4fdb" RANDOM
    public static function beDecryptData($text = "",$key = ""){
        return openssl_decrypt($text,"AES-128-CBC",$key);
    }
}

?>